/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.utils;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateMachine;
import reactor.core.publisher.Mono;

public class StateMachineUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateMachineUtils.class);

    public static <S, E> void sendEvent(StateMachine<S, E> stateMachine, E event) {
        Message message = MessageBuilder.withPayload(event).build();
        stateMachine.sendEvent(Mono.just((Object)message)).subscribe();
    }

    public static <S, E> void restartMachine(StateMachine<S, E> stateMachine) {
        log.info("Restarting stt state machine ...");
        stateMachine.stopReactively().then(stateMachine.startReactively()).subscribe();
    }

    @Generated
    private StateMachineUtils() {
    }
}

