/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.websocket;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.GenerationState;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTWebSocketService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.lang.reflect.Type;
import java.util.Collections;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.ConnectionLostException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

public class StompSessionHandler
extends StompSessionHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StompSessionHandler.class);
    private final String uuid;
    private final STTStatusService statusService;
    private final STTWebSocketService sttWebSocketService;
    private final AlertService alertService;
    private final DialogService dialogService;
    private final MessageService messageService;
    private final AutomaticTranscriptService automaticTranscriptService;
    private StompSession.Subscription subscription;
    private StompSession session;
    private int currentPerson = 0;

    public void afterConnected(StompSession session, @NotNull StompHeaders connectedHeaders) {
        log.info("Connected to websocket.");
        log.debug("Subscribing ...");
        this.session = session;
        this.subscription = session.subscribe("/topic/projects/" + this.uuid, (StompFrameHandler)this);
        this.statusService.setReconnectTriesLeft(3);
        AutomaticTranscriptStatus automaticTranscriptStatus = (AutomaticTranscriptStatus)this.statusService.getLatestStatus().get();
        if (automaticTranscriptStatus != null && automaticTranscriptStatus.getUuid().equals(this.uuid)) {
            this.handleFrame(connectedHeaders, (Object)automaticTranscriptStatus);
        }
    }

    public void handleTransportError(@NotNull StompSession stompSession, @NotNull Throwable throwable) {
        log.error("", throwable);
        if (throwable instanceof ConnectionLostException) {
            log.error("Client has lost connection to WS server.");
            this.statusService.setReconnectTriesLeft(this.statusService.getReconnectTriesLeft() - 1);
            if (this.statusService.getReconnectTriesLeft() > 0) {
                log.info("Reconnecting to websocket ({} retry) ...", (Object)(3 - this.statusService.getReconnectTriesLeft()));
                this.sttWebSocketService.connectToWebSocket(this.uuid);
            } else {
                this.showLostConnectionDialog();
            }
        } else {
            this.showLostConnectionDialog();
        }
    }

    public void handleException(@NonNull StompSession session, StompCommand command, @NonNull StompHeaders headers, byte @NonNull [] payload, @NonNull Throwable exception) {
        log.error("", exception);
    }

    private void showLostConnectionDialog() {
        Platform.runLater(() -> this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("exceptionAlert.Title"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.connectionLost"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    @NotNull
    public Type getPayloadType(@NotNull StompHeaders stompHeaders) {
        return AutomaticTranscriptStatus.class;
    }

    public void handleFrame(@NotNull StompHeaders stompHeaders, Object o) {
        AutomaticTranscriptStatus p = (AutomaticTranscriptStatus)o;
        this.statusService.getLatestStatus().set((Object)p);
        if (p == null) {
            log.error("Received frame is empty.");
            return;
        }
        log.info("Status from STT: {}", (Object)p);
        this.statusService.getTransferProgressInfo().setEtaFromGenerationServer((long)p.getEta());
        if (p.getCurrentPerson() > this.currentPerson) {
            if (this.currentPerson < 0) {
                log.error("Unexpected ID for current person.");
            } else {
                this.statusService.getTransferProgressInfo().getCompletedUploads().add((Object)((Person)this.automaticTranscriptService.getCurrentInfo().getPersons().get(this.currentPerson)).getUuid());
            }
            this.currentPerson = p.getCurrentPerson();
        }
        if (p.getStatus().equals((Object)GenerationState.ERROR) || p.getStatus().equals((Object)GenerationState.FINISHED)) {
            log.debug("Unsubscribing. Status: {}", (Object)p.getStatus());
            this.subscription.unsubscribe();
            this.session.disconnect();
        }
        if (p.getStatus().equals((Object)GenerationState.ERROR)) {
            log.error("Transcript generation failed.");
            this.statusService.resetCurrentProcess();
            this.alertService.showServerError();
        } else if (p.getStatus().equals((Object)GenerationState.FINISHED)) {
            log.info("Transcript generation finished.");
            this.statusService.startDownloadOfTranscript();
        }
    }

    @Generated
    public StompSessionHandler(String uuid, STTStatusService statusService, STTWebSocketService sttWebSocketService, AlertService alertService, DialogService dialogService, MessageService messageService, AutomaticTranscriptService automaticTranscriptService) {
        this.uuid = uuid;
        this.statusService = statusService;
        this.sttWebSocketService = sttWebSocketService;
        this.alertService = alertService;
        this.dialogService = dialogService;
        this.messageService = messageService;
        this.automaticTranscriptService = automaticTranscriptService;
    }
}

