/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.license.service;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.commons.CredentialsService;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.WindowManagerService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETPopOver;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.PopOverService;
import eu.ewerkzeug.easytranscript3.migrations.manualmigrations.V3_1_0_BETA_1__Auth_flow_Migration;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.license.LicenseController;
import eu.ewerkzeug.easytranscript3.networking.license.model.DeviceInformation;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.networking.license.service.NTPService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.EncryptionService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SignatureException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.security.auth.login.AccountExpiredException;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LicenseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseService.class);
    public static final String X_DEVICE_ID_HEADER = "X-Device-ID";
    private static final HashMap<String, Disposable> disposableHashMap = new HashMap();
    private static final SimpleBooleanProperty loading = new SimpleBooleanProperty(true);
    private static final String FIXED_LICENSE_KEY_USER = "licensekeylogin";
    private static ETPopOver pleaseWaitPopOver;
    private final ConfigurationService configurationService;
    private final WindowManagerService windowManagerService;
    private final LicenseValidationService licenseValidationService;
    private final CredentialsService credentialsService;
    private final EncryptionService encryptionService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final PopOverService popOverService;
    private final ExceptionAlert exceptionAlert;
    private final GuiStateService guiStateService;
    private final NTPService nTPService;
    WebClient webClient;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;
    private boolean trialDialogShown = false;
    private ETDialog trialDialog;

    public LicenseService(WindowManagerService windowManagerService, ConfigurationService configurationService, LicenseValidationService licenseValidationService, CredentialsService credentialsService, EncryptionService encryptionService, MessageService messageService, DialogService dialogService, PopOverService popOverService, @Lazy ExceptionAlert exceptionAlert, GuiStateService guiStateService, NTPService nTPService) {
        this.windowManagerService = windowManagerService;
        this.configurationService = configurationService;
        this.licenseValidationService = licenseValidationService;
        this.credentialsService = credentialsService;
        this.encryptionService = encryptionService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.popOverService = popOverService;
        this.exceptionAlert = exceptionAlert;
        this.guiStateService = guiStateService;
        this.nTPService = nTPService;
    }

    private static void doAfterLicenseRequest() {
        V3_1_0_BETA_1__Auth_flow_Migration.deleteToken();
    }

    public void deleteLocalLicense() throws IOException {
        log.debug("Removing license...");
        Files.deleteIfExists(Path.of(LicenseValidationService.LICENSE_PATH, new String[0]));
        this.clearCredentials();
        try {
            this.licenseValidationService.clearUserLicense();
        }
        catch (Exception e) {
            log.warn("Could not clear user license from bean context", (Throwable)e);
        }
        log.info("Removed license.");
    }

    public UserLicense getUserLicense() {
        try {
            return this.licenseValidationService.getUserLicense();
        }
        catch (Exception e) {
            log.warn("Could not get user license from bean context", (Throwable)e);
            return null;
        }
    }

    public Pair<String, String> getLicenseCredentials() {
        return this.credentialsService.getLicenseCredentials();
    }

    public void goToShop() {
        SpringBootJavaFxApplication.getApplication().getHostServices().showDocument("https://easytranscript.de");
    }

    public void clearCredentials() {
        log.debug("Clearing credentials...");
        try {
            this.credentialsService.clearCredentials();
        }
        catch (IOException e) {
            log.error("Could not clear credentials.", (Throwable)e);
        }
        log.info("Cleared credentials.");
    }

    public boolean showLicenseNotValidDialog(boolean showDialogIfLicenseMissing) {
        ButtonType result;
        if (showDialogIfLicenseMissing && loading.get()) {
            if (pleaseWaitPopOver == null) {
                pleaseWaitPopOver = this.popOverService.showSnackbar(this.messageService.getLocaleBundle().getString("general.pleaseWaitLicenseTitle"), this.messageService.getLocaleBundle().getString("general.pleaseWaitLicense"), Duration.ofSeconds(5L));
            } else {
                pleaseWaitPopOver.show();
            }
            return false;
        }
        log.debug("Showing license not valid dialog.");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType toShop = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("licenseScreen.goToShop"), ButtonBar.ButtonData.HELP), false, false);
        ETButtonType enterLicense = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("licenseScreen.enterLicense"), ButtonBar.ButtonData.NEXT_FORWARD), true, true);
        buttons.add(toShop);
        buttons.add(enterLicense);
        ETDialog etDialog = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("general.licenseNeeded"), "", Modality.WINDOW_MODAL, buttons);
        UserLicense userLicense = this.licenseValidationService.getUserLicense();
        if (userLicense == null) {
            log.debug("Reason: user license is null.");
            etDialog.setText(this.messageService.getLocaleBundle().getString("general.licenseNeededDetails"));
            if (!showDialogIfLicenseMissing) {
                return false;
            }
        } else if (!this.licenseValidationService.isLicenseNotExpired()) {
            log.debug("Reason: user license is expired.");
            try {
                this.deleteLocalLicense();
            }
            catch (IOException e) {
                log.error("Could not delete license.", (Throwable)e);
            }
            etDialog.setText(this.messageService.getLocaleBundle().getString("general.licenseExpiredDetails"));
        } else if (!this.nTPService.isOffsetTolerable() || !this.licenseValidationService.isReceivedDateBeforeCurrentDatePublic()) {
            log.debug("Reason: system clock is not set correctly.");
            log.debug("NTP Time offset tolerable: {}", (Object)this.nTPService.isOffsetTolerable());
            log.debug("Offset: {}", (Object)NTPService.getLatestOffset());
            log.debug("Received Date before current date: {}", (Object)this.licenseValidationService.isReceivedDateBeforeCurrentDatePublic());
            etDialog.setText(this.messageService.getLocaleBundle().getString("general.clockNotSetCorrectly"));
        } else if (!this.licenseValidationService.isOfflineDurationTolerable()) {
            log.debug("Reason: User has been offline for too long.");
            etDialog.setText(this.messageService.getLocaleBundle().getString("licenseScreen.revalidationNeeded"));
        }
        if ((result = etDialog.showAndWait()) != null && result == toShop.getButtonType()) {
            this.goToShop();
            return true;
        }
        if (result != null && result == enterLicense.getButtonType()) {
            this.windowManagerService.findOpenWindowByController(LicenseController.class).ifPresent(Window::hide);
            ExtendedController extendedController = this.guiStateService.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
            extendedController.getStage().hide();
            extendedController.getStage().show();
            return true;
        }
        return false;
    }

    @NotNull
    private DeviceInformation getDeviceInformation() {
        DeviceInformation deviceInformation = new DeviceInformation();
        deviceInformation.setLang(this.configurationService.getConfiguration().getProgramLanguage());
        deviceInformation.setDeviceName(Utils.getRealHostname());
        deviceInformation.setOs(System.getProperty("os.name"));
        deviceInformation.setVersion(this.configurationService.getVersion().toString());
        return deviceInformation;
    }

    public void saveCredentials(String username, String password) {
        log.debug("Saving credentials.");
        ImmutablePair licenseCredentials = new ImmutablePair((Object)username, (Object)password);
        try {
            this.credentialsService.storeCredentials(this.encryptionService.encrypt((Serializable)licenseCredentials));
            log.info("Credentials saved/updated.");
        }
        catch (IOException e) {
            log.error("Could not write credentials.", (Throwable)e);
        }
    }

    public void saveLicenseKey(String licenseKey) {
        log.debug("Saving license key.");
        this.saveCredentials("licensekeylogin", licenseKey);
    }

    @PostConstruct
    public void setup() {
        log.debug("License server url is {}.", (Object)this.licenseServerUrl);
        HttpClient httpClient = (HttpClient)HttpClient.create().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
        this.webClient = WebClient.builder().baseUrl(this.licenseServerUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public boolean showLicenseNotValidDialog() {
        return this.showLicenseNotValidDialog(true);
    }

    public void loadLicenseFromDisk() throws SignatureException, AccountExpiredException, IOException {
        this.licenseValidationService.loadLicenseFromDisk();
    }

    public void showLicenseActivatedDialog() {
        this.dialogService.get(this.messageService.getLocaleBundle().getString("licenseScreen.licenseActivatedTitle"), this.messageService.getLocaleBundle().getString("licenseScreen.licenseActivated")).showAndWait();
        if (this.trialDialog != null) {
            this.trialDialog.getStage().hide();
        }
    }

    public void showTrialVersionDialog() {
        if (this.trialDialogShown) {
            return;
        }
        log.info("Showing trial version dialog ...");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType toShop = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("licenseScreen.goToShop"), ButtonBar.ButtonData.APPLY), false, false);
        ETButtonType enterLicense = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("licenseScreen.enterLicense"), ButtonBar.ButtonData.APPLY), false, false);
        ETButtonType okButton = new ETButtonType(ButtonType.OK, true, true);
        buttons.add(toShop);
        buttons.add(enterLicense);
        buttons.add(okButton);
        this.trialDialog = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("licenseScreen.thisIsATestVersionTitle"), this.messageService.getLocaleBundle().getString("licenseScreen.thisIsATestVersion"), Modality.WINDOW_MODAL, buttons);
        this.trialDialog.getStage().toFront();
        this.trialDialogShown = true;
        ButtonType buttonType = this.trialDialog.showAndWait();
        if (buttonType != null) {
            if (buttonType == toShop.getButtonType()) {
                this.goToShop();
            } else if (buttonType == enterLicense.getButtonType()) {
                this.guiStateService.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
            }
        }
        this.trialDialog = null;
    }

    public Mono<ResponseEntity<ByteArrayResource>> getLicenseFromServer(boolean sendMail) throws NullPointerException {
        log.debug("Getting license from Server...");
        DeviceInformation deviceInformation = this.getDeviceInformation();
        return this.credentialsService.executeAuthenticated(headers -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/users/easytranscript?sendMail=" + sendMail, new Object[0])).headers(headers)).body((Publisher)Mono.just((Object)deviceInformation), DeviceInformation.class).retrieve().toEntity(ByteArrayResource.class)).onErrorResume(f -> {
            WebClientResponseException ex;
            if (f instanceof WebClientResponseException && ((ex = (WebClientResponseException)f).getStatusCode().value() == HttpStatus.TOO_MANY_REQUESTS.value() || ex.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value())) {
                try {
                    this.deleteLocalLicense();
                    if (!sendMail) {
                        Platform.runLater(() -> this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.credentialsInvalidOrLicenseActivated")).showAndWait());
                    }
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                    this.exceptionAlert.showModal();
                }
            }
            return Mono.error((Throwable)f);
        }).doFinally(signalType -> LicenseService.doAfterLicenseRequest());
    }

    public Mono<Long> getBalanceInSeconds() throws NullPointerException {
        log.debug("Getting balance from Server...");
        DeviceInformation deviceInformation = this.getDeviceInformation();
        return this.credentialsService.executeAuthenticated(headers -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/users/easytranscript/balance", new Object[0])).headers(headers)).body((Publisher)Mono.just((Object)deviceInformation), DeviceInformation.class).retrieve().bodyToMono(Long.class)).doOnSuccess(balance -> log.info("Balance: {}", balance));
    }

    public void writeByteArrayLicense(byte[] byteArray) {
        log.debug("Writing license bytes ...");
        log.debug("Path: {}", (Object)LicenseValidationService.LICENSE_PATH);
        if (byteArray != null) {
            try {
                Path path = Path.of(LicenseValidationService.LICENSE_PATH, new String[0]);
                Files.write(path, byteArray, new OpenOption[0]);
                Utils.markAsHidden((Path)path);
                log.info("Wrote bytes of license.");
            }
            catch (IOException e) {
                log.error("Could not write license.", (Throwable)e);
            }
        } else {
            log.error("Response Body was empty when loading license.");
        }
    }

    public Mono<ResponseEntity<Void>> logout() {
        log.debug("Logging user out ...");
        Consumer headers = this.credentialsService.getAuthHeadersForFullAuthenticationConsumer();
        if (headers == null) {
            return Mono.error(NullPointerException::new);
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/logout", new Object[0])).headers(headers)).bodyValue((Object)"").retrieve().toBodilessEntity();
    }

    @Generated
    public static HashMap<String, Disposable> getDisposableHashMap() {
        return disposableHashMap;
    }

    @Generated
    public static SimpleBooleanProperty getLoading() {
        return loading;
    }

    @Generated
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }
}

