/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.license.service;

import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.NTPService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.SignatureException;
import java.util.Date;
import javax.security.auth.login.AccountExpiredException;
import javax0.license3j.License;
import javax0.license3j.io.LicenseReader;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LicenseValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseValidationService.class);
    public static final String LICENSE_PATH = Configuration.ET_HOME + "/.license.bin";
    private final byte[] key = new byte[]{82, 83, 65, 0, 48, -126, 2, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 2, 15, 0, 48, -126, 2, 10, 2, -126, 2, 1, 0, -51, -34, 4, 100, 18, 57, -91, 80, -126, 63, -74, 84, 92, -122, 71, -87, -44, 67, -86, 109, -16, 11, -51, 54, 3, 97, -109, -105, 53, -70, -26, -93, 45, 40, 59, 15, -7, -107, -79, 126, -95, -3, 46, 14, -81, -36, 117, -100, -99, 96, 113, -85, -19, -119, -113, -65, -69, -101, -69, -88, 113, -126, 59, -38, 77, -59, 89, 60, 107, -14, 37, -85, -115, 109, -98, -72, 12, -33, 30, 109, 56, -13, 71, -29, -103, -123, 105, 105, -19, -6, -128, -98, -23, 52, 124, -107, -47, 66, -99, 112, 70, -119, 118, 109, 110, -94, 62, 52, 6, 13, -102, 42, -69, -80, 46, -77, 87, -49, -34, -7, 51, 68, 52, -96, 66, -44, -99, -61, -88, -47, 125, 36, 61, 32, -64, -111, -79, -101, -75, 4, 95, -69, -71, -122, 65, 30, -114, 20, -94, 24, -102, 73, -82, -36, 40, 15, -87, -100, 110, -57, 25, 39, -9, 67, 10, 8, 61, 63, -33, -90, 20, 99, -124, 109, -116, 36, 125, -65, 108, -24, 52, 46, 50, 114, 20, 61, -81, -120, 6, -91, -114, -92, -101, -11, 96, 94, -75, -128, -26, -52, -52, 116, -111, 110, 53, -71, -70, -107, 116, -122, -112, 103, 69, -85, -28, 96, 39, -96, -126, -55, 50, -101, 13, 65, -105, -45, 84, -66, 68, 115, 82, 3, 41, -86, -80, -14, 90, -45, -112, -96, -33, -97, 73, 8, -102, -66, 116, -25, 25, -74, 53, -84, 62, -10, -119, -31, 48, -31, 106, 72, 84, 45, 61, -51, 18, -29, -37, -6, -95, 27, 121, 114, 101, 85, 76, -53, 89, -100, -121, 52, 24, 87, 76, -50, -67, 28, 71, -16, 72, 114, -53, -49, 74, 87, -26, -32, -102, 89, -100, 50, 10, -33, -13, 70, 73, 68, 14, -56, 62, -40, 125, -9, 115, -81, 2, -45, 71, -40, -86, -106, 48, -97, -46, -10, 90, 114, 10, -8, -23, 71, 106, -122, -121, 90, -64, 86, 110, 43, -126, -26, 62, -50, 53, 21, 21, 56, 1, -51, 95, -86, -17, 97, -4, 25, 21, -74, -117, 55, 76, -127, -63, -112, -112, -8, 1, 92, 37, -56, 72, 108, 91, -35, 103, 74, -37, 93, 39, -12, 12, 33, 33, -94, -85, 106, 88, -12, -88, 27, -76, -87, 95, 87, 112, -122, -122, -83, 115, -49, -31, 103, -57, 42, -118, -88, -55, 26, 11, 20, 9, 40, 60, -93, -1, -68, -63, -61, 106, -110, -112, -39, -106, 98, 82, 87, -51, -12, 73, 60, -16, -3, 99, -54, 86, -15, -112, 105, 107, -119, 8, 54, -96, 95, -18, -34, 57, 101, -113, -32, -80, 25, -80, -1, -24, 35, -80, 108, 23, -75, 89, -121, -46, 95, 57, -99, 102, 102, -16, 45, 52, 57, -55, -29, 95, -42, 107, 16, -17, 84, -26, 29, -27, 63, -82, -76, 69, -22, -10, 39, 0, -56, -90, 10, -27, 11, -89, -101, -32, 27, -82, -108, -5, 5, 107, 57, -56, 33, -60, -53, -7, -31, -16, 3, 2, 3, 1, 0, 1};
    private UserLicense userLicense;
    private final NTPService ntpService;

    public void loadLicenseFromDisk() throws SignatureException, AccountExpiredException, IOException {
        log.debug("Loading license from disk...");
        Path path = this.getLicensePath();
        if (!Files.exists(path, new LinkOption[0])) {
            log.info("No license saved on disk.");
            return;
        }
        try {
            byte[] licenseBytes = Files.readAllBytes(path);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(licenseBytes);
                 LicenseReader licenseReader = new LicenseReader((InputStream)bais);){
                License license = licenseReader.read();
                log.info("Loaded license from disk.");
                if (!license.isOK(this.key)) {
                    log.error("License is not valid!");
                    this.userLicense = null;
                    throw new SignatureException("License is not valid!");
                }
                this.mapLicenseToUserLicense(license);
                if (!this.isUserLicenseValid()) {
                    log.error("User License is not valid!");
                    throw new AccountExpiredException("User License is not valid!");
                }
            }
        }
        catch (IOException e) {
            log.error("Could not read license", (Throwable)e);
            this.userLicense = null;
            throw e;
        }
    }

    protected Path getLicensePath() {
        return Path.of(LICENSE_PATH, new String[0]);
    }

    public boolean isUserLicenseValid() {
        log.debug("Checking if user license is valid.");
        if (this.userLicense == null) {
            log.warn("User License is null!");
            return false;
        }
        log.debug("Expiry date is: {}", (Object)this.userLicense.getExpiryDate());
        log.debug("Received date is: {}", (Object)this.userLicense.getReceivedDate());
        log.debug("Maximum offline duration is: {}", (Object)this.userLicense.getMaxOfflineDuration());
        boolean notExpired = this.isLicenseNotExpired();
        boolean receivedBeforeCurrentDate = this.isReceivedDateBeforeCurrentDate();
        boolean offsetTolerable = this.ntpService.isOffsetTolerable();
        boolean offlineTimeTolerable = this.isOfflineDurationTolerable();
        if (!notExpired) {
            log.warn("User license has expired.");
        }
        if (this.userLicense.getReceivedDate() != null) {
            if (!receivedBeforeCurrentDate) {
                log.warn("Received date of license is after current date!");
            }
            if (!offlineTimeTolerable) {
                log.warn("User has been offline for longer than {} days ({} ms)", (Object)(this.userLicense.getMaxOfflineDuration() / 1000L / 60L / 60L / 24L), (Object)this.userLicense.getMaxOfflineDuration());
            }
        } else {
            log.warn("No received date found!");
        }
        if (!offsetTolerable) {
            log.warn("System clock offset is {}, too big!", (Object)this.ntpService.getOffset());
        }
        boolean returner = notExpired && offsetTolerable && offlineTimeTolerable;
        log.debug("License is{}valid.", (Object)(returner ? " " : " not "));
        return returner;
    }

    private Date getReceivedWithTolerance() {
        return new Date(this.userLicense.getReceivedDate().getTime() - Math.max(0L, this.ntpService.getOffset()));
    }

    private boolean isReceivedDateBeforeCurrentDate() {
        return this.userLicense.getReceivedDate() != null && !this.getReceivedWithTolerance().after(new Date());
    }

    public boolean isLicenseNotExpired() {
        return this.userLicense.getExpiryDate() == null || this.userLicense.getExpiryDate().after(new Date());
    }

    public boolean isOfflineDurationTolerable() {
        return new Date(this.getReceivedWithTolerance().getTime() + this.userLicense.getMaxOfflineDuration()).after(new Date());
    }

    public boolean isReceivedDateBeforeCurrentDatePublic() {
        return this.isReceivedDateBeforeCurrentDate();
    }

    private void mapLicenseToUserLicense(License license) {
        this.userLicense = new UserLicense();
        this.userLicense.setAllowedNumber(license.get("allowedNumber").getInt());
        if (license.get("expiryDate") != null) {
            this.userLicense.setExpiryDate(license.get("expiryDate").getDate());
        }
        this.userLicense.setFirstname(license.get("firstname").getString());
        this.userLicense.setLastname(license.get("lastname").getString());
        if (license.get("company") != null) {
            this.userLicense.setCompany(license.get("company").getString());
        }
        if (license.get("sttEnabled") != null) {
            this.userLicense.setSttEnabled(license.get("sttEnabled").getByte() != 0);
        }
        this.userLicense.setReceivedDate(license.get("receivedDate").getDate());
        this.userLicense.setMaxOfflineDuration(license.get("maxOfflineDuration").getLong());
        if (license.get("username") != null) {
            this.userLicense.setUsername(license.get("username").getString());
        }
    }

    public void clearUserLicense() {
        this.userLicense = null;
    }

    @Generated
    public LicenseValidationService(NTPService ntpService) {
        this.ntpService = ntpService;
    }

    @Generated
    public UserLicense getUserLicense() {
        return this.userLicense;
    }
}

