/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.license.service;

import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NTPService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NTPService.class);
    private static long latestOffset = 0L;
    public static final Duration OFFSET_TOLERANCE = Duration.ofMinutes(30L);

    public void getNTPTime() {
        log.debug("Requesting NTP time from pool.ntp.org...");
        try (NTPUDPClient client = new NTPUDPClient();){
            client.setDefaultTimeout(Duration.ofSeconds(10L));
            client.open();
            InetAddress hostAddr = InetAddress.getByName("pool.ntp.org");
            TimeInfo info = client.getTime(hostAddr);
            info.computeDetails();
            Long offset = info.getOffset();
            latestOffset = offset != null ? offset : 0L;
            log.debug("Time offset calculated: {} ms", (Object)latestOffset);
        }
        catch (IOException e) {
            log.error("NTP retrieval failed. Keeping old offset or 0.", (Throwable)e);
        }
    }

    public boolean isOffsetTolerable() {
        return Math.abs(latestOffset) < OFFSET_TOLERANCE.toMillis();
    }

    public long getOffset() {
        return latestOffset;
    }

    @Generated
    public static long getLatestOffset() {
        return latestOffset;
    }
}

