/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.util.Collections;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlertService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertService.class);
    private final DialogService dialogService;
    private final MessageService messageService;

    public void showServerError() {
        String title = this.messageService.getLocaleBundle().getString("general.genericResponseServerErrorTitle");
        String content = this.messageService.getLocaleBundle().getString("general.genericResponseServerError");
        Platform.runLater(() -> this.dialogService.createDialog(title, content, Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public void showConnectionError() {
        Platform.runLater(() -> this.dialogService.createDialog("", this.messageService.getLocaleBundle().getString("general.noConnectionToServer"), Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    @Generated
    public AlertService(DialogService dialogService, MessageService messageService) {
        this.dialogService = dialogService;
        this.messageService = messageService;
    }
}

