/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.LocalCreationInfo;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tools.jackson.databind.ObjectMapper;

@Service
public class AutomaticTranscriptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutomaticTranscriptService.class);
    public static final Path AUTOMATIC_TRANSCRIPTION_INFORMATION_PATH = Path.of(Configuration.ET_HOME, ".atci.json");
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;
    private final ExceptionAlert exceptionAlert;
    private AutomaticTranscriptCreationInfo currentInfo = new AutomaticTranscriptCreationInfo();

    public void reset() {
        this.currentInfo = new AutomaticTranscriptCreationInfo();
        this.currentInfo.setUsedETVersion(this.configurationService.getVersion());
    }

    public void save(AutomaticTranscriptCreationInfo info) {
        log.debug("Saving automatic transcript creation info ...");
        this.deleteSavedFile();
        info.setUsedETVersion(this.configurationService.getVersion());
        this.objectMapper.writeValue(this.getAutomaticTranscriptionInformationPath().toFile(), (Object)LocalCreationInfo.ofAutomaticTranscriptCreationInfo((AutomaticTranscriptCreationInfo)info));
        Utils.markAsHidden((Path)this.getAutomaticTranscriptionInformationPath());
        log.debug("Saved automatic transcript creation info.");
    }

    public synchronized void load() {
        log.debug("Loading automatic transcript creation info ...");
        File f = this.getAutomaticTranscriptionInformationPath().toFile();
        if (!f.exists() || !f.isFile()) {
            log.info("Could not read automatic transcript creation info because file does not exist.");
            return;
        }
        try {
            String json = Files.readString(f.toPath());
            json = Utils.removeControlCharactersFromJSON((String)json);
            LocalCreationInfo i = (LocalCreationInfo)this.objectMapper.readValue(json, LocalCreationInfo.class);
            this.fromLocalCreationInfo(i);
            log.info("Loaded automatic transcript creation info.");
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
        }
    }

    public void deleteSavedFile() {
        log.debug("Deleting saved automatic transcript creation info ...");
        try {
            Files.deleteIfExists(this.getAutomaticTranscriptionInformationPath());
            log.info("Deleted automatic transcript creation info.");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
        }
    }

    private void fromLocalCreationInfo(LocalCreationInfo i) {
        this.reset();
        this.currentInfo.setUuid(i.getUuid());
        this.currentInfo.setTranscriptLocation(i.getTranscriptLocation());
        this.currentInfo.setTranscriptionRuleSet(i.getTranscriptionRuleSet());
        this.currentInfo.getDomainDictionary().addAll(i.getDomainDictionary());
        this.currentInfo.getPersons().addAll((Collection)i.getPersons());
        this.currentInfo.setConfidenceThreshold(i.getConfidenceThreshold());
        this.currentInfo.setAsrEngineKey(i.getAsrEngineKey());
        this.currentInfo.setUsedETVersion(i.getUsedETVersion());
    }

    protected Path getAutomaticTranscriptionInformationPath() {
        return AUTOMATIC_TRANSCRIPTION_INFORMATION_PATH;
    }

    @Generated
    public AutomaticTranscriptService(ObjectMapper objectMapper, ConfigurationService configurationService, ExceptionAlert exceptionAlert) {
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
        this.exceptionAlert = exceptionAlert;
    }

    @Generated
    public AutomaticTranscriptCreationInfo getCurrentInfo() {
        return this.currentInfo;
    }
}

