/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import tools.jackson.databind.ObjectMapper;

@Service
public class ConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private static final String PROGRAM_SETTINGS_NAME = "programSettings.json";
    private final ObjectMapper objectMapper;
    private final Configuration configuration = new Configuration();
    private final ExceptionAlert exceptionAlert;
    private Version version = Version.of((long)0L);
    private String commitIdOfVersion = "unknown";
    private String commitDateOfVersion = "unknown";

    public ConfigurationService(ObjectMapper objectMapper, @Lazy ExceptionAlert exceptionAlert) {
        this.objectMapper = objectMapper;
        this.exceptionAlert = exceptionAlert;
    }

    @PostConstruct
    public void init() {
        this.loadVersionProperties();
        this.loadGitProperties();
        Path configPath = this.getEtHome().resolve(PROGRAM_SETTINGS_NAME);
        if (!Files.exists(configPath, new LinkOption[0])) {
            log.info("Configuration file does not exist yet in {}", (Object)configPath);
            this.initialize();
        } else {
            try {
                this.load();
                Utils.setLoggingLevel((String)this.configuration.getLogLevel());
            }
            catch (Exception e) {
                this.initialize();
                log.error("Malformed programSettings. Reinitialized.", (Throwable)e);
            }
        }
    }

    private void loadVersionProperties() {
        log.debug("Reading version properties...");
        try (InputStream is = this.getClass().getResourceAsStream("/version.properties");){
            if (is != null) {
                Properties versionProp = new Properties();
                versionProp.load(is);
                this.version = this.getVersionFromString(versionProp.get("version").toString());
            }
        }
        catch (IOException | NullPointerException e) {
            log.error("Could not read version properties", (Throwable)e);
        }
    }

    private void loadGitProperties() {
        log.debug("Reading git properties...");
        try (InputStream is = this.getClass().getResourceAsStream("/git.properties");){
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                this.commitIdOfVersion = p.getProperty("git.commit.id.abbrev");
                this.commitDateOfVersion = p.getProperty("git.commit.time");
            }
        }
        catch (IOException e) {
            log.error("Could not read git properties", (Throwable)e);
        }
    }

    private Version getVersionFromString(String versionString) {
        try {
            return Version.parse((String)versionString);
        }
        catch (UnexpectedCharacterException e) {
            log.error("Could not read version from version.properties.", (Throwable)e);
            return Version.of((long)3L, (long)99L, (long)0L);
        }
    }

    public synchronized void initialize() {
        log.debug("Initializing configuration...");
        this.save();
        log.info("Initialized Configuration.");
    }

    public synchronized void save() {
        log.debug("Saving Configuration ...");
        Path configPath = this.getEtHome().resolve(PROGRAM_SETTINGS_NAME);
        Path tempPath = this.getEtHome().resolve("programSettings.json.tmp");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            this.objectMapper.writeValue(tempPath.toFile(), (Object)this.configuration);
            Files.move(tempPath, configPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            log.info("Saved Configuration.");
        }
        catch (IOException e) {
            log.error("Failed to save configuration", (Throwable)e);
            this.exceptionAlert.showModal();
        }
    }

    public synchronized void load() {
        File file = this.getEtHome().resolve(PROGRAM_SETTINGS_NAME).toFile();
        log.debug("Loading Configuration from {}...", (Object)file.getAbsolutePath());
        try {
            String json = Files.readString(file.toPath());
            json = Utils.removeControlCharactersFromJSON((String)json);
            Configuration loadedConfig = (Configuration)this.objectMapper.readValue(json, Configuration.class);
            this.configuration.copyFrom(loadedConfig);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
            return;
        }
        this.validateConfiguration();
        log.info("Loaded configuration.");
    }

    private void validateConfiguration() {
        boolean malformed = false;
        try {
            DateTimeFormatter.ofPattern(this.configuration.getTimestampsFormat());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.error("Timestamp pattern {} is invalid.", (Object)this.configuration.getTimestampsFormat());
            this.configuration.setTimestampsFormat("#HH:mm:ss-SSS#");
            malformed = true;
        }
        if (malformed) {
            log.warn("Configuration has been corrected and needs to get saved.");
            this.save();
        }
    }

    protected Path getEtHome() {
        return Path.of(Configuration.ET_HOME, new String[0]);
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    @Generated
    public String getCommitIdOfVersion() {
        return this.commitIdOfVersion;
    }

    @Generated
    public String getCommitDateOfVersion() {
        return this.commitDateOfVersion;
    }
}

