/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.ArrayType;

@Service
public class CorrectionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CorrectionService.class);
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;
    private final Map<String, String> corrections = new HashMap();
    private final ChangeListener<String> languageListener = (observable, oldValue, newValue) -> this.loadCorrections();

    @PostConstruct
    public void init() {
        this.loadCorrections();
        this.configurationService.getConfiguration().programLanguageProperty().addListener(this.languageListener);
    }

    private void loadCorrections() {
        this.corrections.clear();
        String language = this.configurationService.getConfiguration().getProgramLanguage();
        log.debug("Loading misspelling corrections for language: {}", (Object)language);
        String resourcePath = null;
        if ("de".equals(language)) {
            resourcePath = "/substitutions/misspellings_de.json";
        } else if ("en".equals(language)) {
            resourcePath = "/substitutions/misspellings_en.json";
        }
        if (resourcePath != null) {
            try {
                Pair[] pairs;
                ArrayType pairType = this.objectMapper.getTypeFactory().constructArrayType(this.objectMapper.getTypeFactory().constructParametricType(Pair.class, new Class[]{String.class, String.class}));
                for (Pair pair : pairs = (Pair[])this.objectMapper.readValue(Utils.class.getResourceAsStream(resourcePath), (JavaType)pairType)) {
                    this.corrections.put(((String)pair.getKey()).replace("*", "").toLowerCase(), ((String)pair.getValue()).replace("*", ""));
                }
                log.info("Loaded {} corrections for language {}", (Object)this.corrections.size(), (Object)language);
            }
            catch (NullPointerException e) {
                log.error("Could not read misspellings from {}", (Object)resourcePath, (Object)e);
            }
        } else {
            log.debug("No corrections available for language {}", (Object)language);
        }
    }

    public Map<String, String> getMisspellingCorrections() {
        return new HashMap<String, String>(this.corrections);
    }

    @Generated
    public CorrectionService(ObjectMapper objectMapper, ConfigurationService configurationService) {
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
    }
}

