/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.stereotype.Service;

@Service
public class EncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionService.class);
    @Value(value="${easytranscript.security.aes.password}")
    private String password;
    @Value(value="${easytranscript.security.aes.salt}")
    private String salt;
    private BytesEncryptor encryptor;

    @PostConstruct
    public void init() {
        if (this.password == null || this.salt == null) {
            log.error("Encryption password or salt is missing in configuration!");
            throw new IllegalStateException("Encryption configuration missing");
        }
        this.encryptor = Encryptors.stronger((CharSequence)this.password, (CharSequence)this.salt);
    }

    public byte[] encrypt(Serializable unencrypted) {
        return this.encryptor.encrypt(SerializationUtils.serialize((Serializable)unencrypted));
    }

    public <E> E decrypt(byte[] bytes) {
        return (E)SerializationUtils.deserialize((byte[])this.encryptor.decrypt(bytes));
    }
}

