/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.paint.Color;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;

@Service
public class TextStyleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextStyleService.class);
    private final ConfigurationService configurationService;

    public TextStyle getDefaultStyle() {
        Configuration config = this.configurationService.getConfiguration();
        return new TextStyle(Optional.of(config.isFormattingBold()), Optional.of(config.isFormattingItalic()), Optional.of(config.isFormattingUnderlined()), Optional.empty(), Optional.of(config.getFormattingSize()), Optional.of(config.getFormattingFont()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ETStyle getETStyleWithDefaults(ETStyle etStyle) {
        Configuration config = this.configurationService.getConfiguration();
        Optional bold = etStyle.getBold().or(() -> Optional.of(config.isFormattingBold()));
        Optional italic = etStyle.getItalic().or(() -> Optional.of(config.isFormattingItalic()));
        Optional underline = etStyle.getUnderlined().or(() -> Optional.of(config.isFormattingUnderlined()));
        Optional fontSize = etStyle.getFontSize().or(() -> Optional.of(config.getFormattingSize()));
        Optional fontFamily = etStyle.getFontFamily().or(() -> Optional.of(config.getFormattingFont()));
        Optional<Color> color = etStyle.getColor().map(TextStyle::cssColor);
        ETStyle withDefaults = new ETStyle();
        withDefaults.setBold(((Boolean)bold.get()).booleanValue());
        withDefaults.setItalic(((Boolean)italic.get()).booleanValue());
        withDefaults.setUnderlined(((Boolean)underline.get()).booleanValue());
        withDefaults.setFontSize(((Integer)fontSize.get()).intValue());
        withDefaults.setFontFamily((String)fontFamily.get());
        withDefaults.setColor((String)color.map(Color::toString).orElse(null));
        return withDefaults;
    }

    public TextStyle resolveETStyle(ETStyle etStyle) {
        Configuration config = this.configurationService.getConfiguration();
        return new TextStyle(etStyle.getBold().or(() -> Optional.of(config.isFormattingBold())), etStyle.getItalic().or(() -> Optional.of(config.isFormattingItalic())), etStyle.getUnderlined().or(() -> Optional.of(config.isFormattingUnderlined())), Optional.empty(), etStyle.getFontSize().isPresent() ? etStyle.getFontSize() : Optional.of(config.getFormattingSize()), etStyle.getFontFamily().isPresent() ? etStyle.getFontFamily() : Optional.of(config.getFormattingFont()), Optional.of(Color.BLACK), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TextStyle fromCss(String style) {
        Configuration config = this.configurationService.getConfiguration();
        Optional<Boolean> bold = Optional.of(config.isFormattingBold());
        Optional<Boolean> italic = Optional.of(config.isFormattingItalic());
        Optional<Boolean> underline = Optional.of(config.isFormattingUnderlined());
        Optional<Object> strikethrough = Optional.empty();
        Optional<Integer> fontSize = Optional.of(config.getFormattingSize());
        Optional<String> fontFamily = Optional.of(config.getFormattingFont());
        Optional<Object> textColor = Optional.empty();
        Optional<Object> backgroundColor = Optional.empty();
        if (!style.isEmpty()) {
            block21: for (String property : style.split(";")) {
                String[] pair = property.split(":");
                if (pair.length < 2) continue;
                String propName = pair[0].trim();
                Object propValue = pair[1].trim();
                switch (propName) {
                    case "-fx-font-size": {
                        Pattern pattern = Pattern.compile("(\\d*)pt");
                        Matcher matcher = pattern.matcher((CharSequence)propValue);
                        int sizePt = 12;
                        if (matcher.find()) {
                            sizePt = Integer.parseInt(matcher.group(1));
                        }
                        fontSize = Optional.of(sizePt);
                        continue block21;
                    }
                    case "-fx-font-family": {
                        if (!((String)propValue).startsWith("\"") && !((String)propValue).endsWith("\"")) {
                            propValue = "\"" + (String)propValue + "\"";
                        }
                        fontFamily = Optional.of(propValue);
                        continue block21;
                    }
                    case "-fx-text-fill": 
                    case "-fx-fill": {
                        textColor = Optional.of(TextStyle.cssColor((String)propValue));
                        continue block21;
                    }
                    case "-fx-font-weight": {
                        bold = Optional.of("bold".equals(propValue));
                        continue block21;
                    }
                    case "-fx-font-style": {
                        italic = Optional.of("italic".equals(propValue));
                        continue block21;
                    }
                    case "-fx-underline": {
                        underline = Optional.of("true".equals(propValue));
                        continue block21;
                    }
                    case "-fx-strikethrough": {
                        strikethrough = Optional.of("true".equals(propValue));
                        continue block21;
                    }
                    case "-rtfx-background-color": {
                        backgroundColor = Optional.of(TextStyle.cssColor((String)propValue));
                        continue block21;
                    }
                }
            }
        }
        return new TextStyle(bold, italic, underline, strikethrough, fontSize, fontFamily, textColor, backgroundColor, Optional.empty(), Optional.empty());
    }

    public TextStyle fromNode(Element styledText) {
        String style = styledText.getAttribute("style");
        TextStyle baseStyle = this.fromCss(style);
        Optional<Object> wordAlternatives = Optional.empty();
        Optional<Object> wordConfidence = Optional.empty();
        if (styledText.hasAttribute("et-word-alternatives")) {
            wordAlternatives = Optional.of(styledText.getAttribute("et-word-alternatives"));
        }
        if (styledText.hasAttribute("et-word-confidence")) {
            try {
                wordConfidence = Optional.of(Float.valueOf(Float.parseFloat(styledText.getAttribute("et-word-confidence"))));
            }
            catch (NumberFormatException e) {
                log.warn("Invalid confidence value: {}", (Object)styledText.getAttribute("et-word-confidence"));
            }
        }
        return new TextStyle(baseStyle.boldOptional, baseStyle.italicOptional, baseStyle.underlineOptional, baseStyle.strikethroughOptional, baseStyle.fontSizeOptional, baseStyle.fontFamilyOptional, baseStyle.textColorOptional, baseStyle.backgroundColorOptional, wordAlternatives, wordConfidence);
    }

    @Generated
    public TextStyleService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

