/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import com.jthemedetecor.OsThemeDetector;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Objects;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.Declaration;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.Stylesheet;
import javafx.scene.Scene;
import javafx.stage.Window;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThemeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThemeService.class);
    private final ConfigurationService configurationService;
    private final HashMap<URI, Stylesheet> readStylesheets = new HashMap();
    private final GuiStateService guiStateService;

    public void setStyleSheets(Scene scene) {
        String path;
        scene.getStylesheets().clear();
        String dark = "eu/ewerkzeug/easytranscript3/darcula.css";
        String light = "eu/ewerkzeug/easytranscript3/light.css";
        if (this.configurationService.getConfiguration().getTheme().equals((Object)Theme.SYNC_WITH_OS)) {
            if (!OsThemeDetector.isSupported()) {
                this.configurationService.getConfiguration().setTheme(Theme.DARK);
                this.configurationService.save();
                path = dark;
            } else {
                try {
                    path = OsThemeDetector.getDetector().isDark() ? dark : light;
                }
                catch (Exception e) {
                    log.error("Failed to detect theme.", (Throwable)e);
                    path = dark;
                }
            }
        } else {
            path = this.configurationService.getConfiguration().getTheme().equals((Object)Theme.DARK) ? dark : light;
        }
        URL base = ExtendedController.class.getClassLoader().getResource("eu/ewerkzeug/easytranscript3/theme.css");
        URL theme = ExtendedController.class.getClassLoader().getResource(path);
        if (base != null) {
            scene.getStylesheets().addFirst((Object)base.toExternalForm());
        }
        if (theme != null) {
            scene.getStylesheets().addFirst((Object)theme.toExternalForm());
        }
    }

    public void reapplyTheme() {
        Platform.runLater(() -> {
            MainController mainController;
            ExtendedController patt0$temp;
            if (this.guiStateService.getMainStage() != null && this.guiStateService.getMainStage().getScene() != null) {
                this.setStyleSheets(this.guiStateService.getMainStage().getScene());
            }
            if ((patt0$temp = this.guiStateService.getController()) instanceof MainController && (mainController = (MainController)patt0$temp).getProgressBarController() != null && mainController.getProgressBarController().stage != null) {
                this.setStyleSheets(mainController.getProgressBarController().stage.getScene());
            }
            Window.getWindows().forEach(window -> {
                if (window.getScene() != null) {
                    this.setStyleSheets(window.getScene());
                }
            });
        });
    }

    public <T> T getCssVariable(String variable) throws URISyntaxException {
        Object result = this.configurationService.getConfiguration().getTheme().equals((Object)Theme.DARK) ? this.getVariableFromUrl(variable, this.getDarculaThemeResource()) : this.getVariableFromUrl(variable, this.getLightThemeResource());
        if (result == null) {
            result = this.getVariableFromUrl(variable, this.getRootThemeResource());
        }
        return (T)result;
    }

    private <T> T getVariableFromUrl(String variable, URI uri) {
        Stylesheet stylesheet = this.readCssFile(uri);
        return (T)this.getVariableFromStylesheet(variable, stylesheet);
    }

    private <T> T getVariableFromStylesheet(String variable, Stylesheet stylesheet) {
        if (stylesheet == null) {
            log.error("Could not get variable '{}'. Stylesheet is null.", (Object)variable);
            return null;
        }
        if (stylesheet.getRules().isEmpty()) {
            return null;
        }
        Rule rootRule = (Rule)stylesheet.getRules().getFirst();
        ObservableList declarations = rootRule.getDeclarations();
        for (Declaration d : declarations) {
            if (!d.getProperty().equals(variable)) continue;
            ParsedValue parsedValue = d.getParsedValue();
            return (T)parsedValue.getValue();
        }
        return null;
    }

    private Stylesheet readCssFile(URI uri) {
        if (!this.readStylesheets.containsKey(uri)) {
            try {
                Stylesheet parse = new CssParser().parse(uri.toURL());
                this.readStylesheets.put(uri, parse);
                return parse;
            }
            catch (IOException e) {
                log.error("Could not read root theme resource.", (Throwable)e);
                return null;
            }
        }
        return (Stylesheet)this.readStylesheets.get(uri);
    }

    public URI getDarculaThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(this.getClass().getResource("/eu/ewerkzeug/easytranscript3/darcula.css")).toURI();
    }

    public URI getLightThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(this.getClass().getResource("/eu/ewerkzeug/easytranscript3/light.css")).toURI();
    }

    public URI getRootThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(this.getClass().getResource("/eu/ewerkzeug/easytranscript3/theme.css")).toURI();
    }

    @Generated
    public ThemeService(ConfigurationService configurationService, GuiStateService guiStateService) {
        this.configurationService = configurationService;
        this.guiStateService = guiStateService;
    }
}

