/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.service;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.io.ETFileNotFoundException;
import eu.ewerkzeug.easytranscript3.commons.io.ZipService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.ThemeService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.input.KeyCombination;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tools.jackson.databind.ObjectMapper;

@Service
public class TranscriptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranscriptService.class);
    private static final String PROPERTIES_FILENAME = "properties.json";
    private static final String DOCUMENT_FILENAME = "document.xml";
    private final ConfigurationService configurationService;
    private final ZipService zipService;
    private final ObjectMapper objectMapper;
    private final ThemeService themeService;
    private final MessageService messageService;
    private final ExceptionAlert exceptionAlert;
    private FileChooser.ExtensionFilter ettFilter;
    private FileChooser.ExtensionFilter etpFilter;
    private FileChooser.ExtensionFilter filter;
    private Transcript currentTranscript = new Transcript();

    @PostConstruct
    public void setup() {
        this.ettFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("mainScreen.filePickerETTranscript") + " (*.ett)", new String[]{"*.ett"});
        this.etpFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("mainScreen.filePickerETPTranscript") + " (*.etp)", new String[]{"*.etp"});
        this.filter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("mainScreen.filePickerAllTranscripts") + " (*.ett, *.etp)", new String[]{"*.ett", "*.etp"});
    }

    public List<FileChooser.ExtensionFilter> getTranscriptExtensionFilters() {
        return List.of(this.filter, this.ettFilter, this.etpFilter);
    }

    public Path getTemporaryTranscriptsLocation() {
        return this.getTempDirectory().resolve("transcripts");
    }

    public Path getTemporaryTranscriptLocation(String uuid) {
        return this.getTemporaryTranscriptsLocation().resolve(uuid);
    }

    public Path getTemporaryTranscriptLocation() {
        return this.getTemporaryTranscriptsLocation().resolve(this.getCurrentTranscript().getUnzipUuid());
    }

    public Path getTemporaryPropertiesLocation(String uuid) {
        return this.getTemporaryTranscriptLocation(uuid).resolve(PROPERTIES_FILENAME);
    }

    public Path getTemporaryPropertiesLocation() {
        return this.getTemporaryTranscriptLocation(this.getCurrentTranscript().getUnzipUuid()).resolve(PROPERTIES_FILENAME);
    }

    public Path getTemporaryDocumentLocation(Transcript transcript) {
        return this.getTemporaryTranscriptLocation(transcript.getUnzipUuid()).resolve(DOCUMENT_FILENAME);
    }

    public Path getTemporaryDocumentLocation() {
        return this.getTemporaryTranscriptLocation(this.getCurrentTranscript().getUnzipUuid()).resolve(DOCUMENT_FILENAME);
    }

    protected Path getTempDirectory() {
        return Main.getEasytranscriptTempDirectory();
    }

    public Transcript loadProperties(String unzipUuid, Path transcriptLocation) throws IOException {
        return this.loadProperties(this.getTemporaryPropertiesLocation(unzipUuid), unzipUuid, transcriptLocation);
    }

    public Transcript loadProperties(Path unzippedPropertiesPath, String unzipUuid, Path transcriptLocation) throws IOException {
        Transcript transcript;
        log.debug("Loading Transcript properties ...");
        if (unzippedPropertiesPath == null) {
            log.warn("Transcript unzip properties path is empty.");
            return new Transcript();
        }
        if (!unzippedPropertiesPath.toFile().exists()) {
            throw new ETFileNotFoundException(this.messageService.getLocaleBundle().getString("problems.transcriptFileNotFound"), "Transcript %s does not exist".formatted(unzippedPropertiesPath.toString()));
        }
        try {
            String json = Files.readString(unzippedPropertiesPath);
            json = Utils.removeControlCharactersFromJSON((String)json);
            transcript = (Transcript)this.objectMapper.readValue(json, Transcript.class);
            transcript.setTranscriptLocation(transcriptLocation);
            transcript.setUnzipUuid(unzipUuid);
            List speakerList = transcript.getSpeakers();
            List speakers = speakerList.stream().distinct().toList();
            speakerList.clear();
            speakerList.addAll(speakers);
        }
        catch (IOException e) {
            log.error("Failed to load transcript properties from path: {}", (Object)unzippedPropertiesPath, (Object)e);
            throw e;
        }
        log.info("Loaded Transcript.");
        return transcript;
    }

    public boolean saveProperties(Transcript transcript) throws IOException {
        return this.saveProperties(transcript, this.getTemporaryPropertiesLocation(transcript.getUnzipUuid()).toFile());
    }

    public boolean saveProperties() throws IOException {
        return this.saveProperties(this.getCurrentTranscript());
    }

    public boolean saveProperties(Transcript transcript, File file) throws IOException {
        log.debug("Saving Transcript ...");
        this.makeKeyCombinationFieldsPlatformIndependent(transcript);
        transcript.setUsedETVersion(this.configurationService.getVersion());
        Path parent = file.toPath().getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        this.objectMapper.writeValue(file, (Object)transcript);
        log.info("Saved Transcript.");
        return true;
    }

    private void makeKeyCombinationFieldsPlatformIndependent(Transcript transcript) {
        LinkedHashMap snapshot = new LinkedHashMap(transcript.getKeyCombinationFields());
        LinkedHashMap<String, String> newKeyCombinationFields = new LinkedHashMap<String, String>();
        for (Map.Entry entry : snapshot.entrySet()) {
            try {
                KeyCombination.valueOf((String)((String)entry.getKey()));
                newKeyCombinationFields.put((String)entry.getKey(), (String)entry.getValue());
            }
            catch (IllegalArgumentException e) {
                String key = KeyCombinationTextField.replaceSpecificByPlatformIndependent((String)((String)entry.getKey()));
                newKeyCombinationFields.put(key, (String)entry.getValue());
            }
        }
        transcript.getKeyCombinationFields().clear();
        transcript.getKeyCombinationFields().putAll(newKeyCombinationFields);
    }

    public String loadDocument(Transcript transcript) throws IOException {
        log.debug("Loading document ...");
        Path unzippedDocumentPath = this.getTemporaryDocumentLocation(transcript);
        if (unzippedDocumentPath.toFile().exists()) {
            return Files.readString(unzippedDocumentPath);
        }
        log.warn("Document %s does not exist".formatted(unzippedDocumentPath.toString()));
        return null;
    }

    public Transcript createShallowCopyForAutoRecover(Transcript transcript) {
        Transcript shallowCopy = new Transcript(transcript);
        shallowCopy.setTranscriptLocation(Path.of(Configuration.ET_HOME + "/backups/" + shallowCopy.getUuid() + ".ett", new String[0]));
        return shallowCopy;
    }

    public void initializeWordCompletionList(Transcript transcript, String parsedText) {
        log.debug("Recreating word list ...");
        if (parsedText.length() < 2) {
            log.info("Text is empty, no words added to list.");
            return;
        }
        List<String> words = Arrays.stream(parsedText.split(Transcript.wordSeparator.pattern())).map(word -> word.replace("\ufffc", "")).filter(word -> !word.isBlank()).toList();
        words = new ArrayList<String>(words);
        boolean endsWithSeparator = Transcript.wordSeparator.matcher(parsedText.substring(parsedText.length() - 1)).matches();
        if (!endsWithSeparator && !words.isEmpty()) {
            words.removeLast();
        }
        Set autocompletionWordSet = words.stream().filter(f -> f.length() >= this.configurationService.getConfiguration().getAutocompletionThreshold()).collect(Collectors.toSet());
        transcript.setAutocompletionWords(autocompletionWordSet);
        log.debug("Created word list. Found {} words matching the threshold of {} letters.", (Object)transcript.getAutocompletionWords().size(), (Object)this.configurationService.getConfiguration().getAutocompletionThreshold());
    }

    public void updateSpeakerTextStyle(Transcript transcript) {
        transcript.setSpeakerTextStyle(this.createSpeakerTextStyle(transcript));
    }

    private TextStyle createSpeakerTextStyle(Transcript transcript) {
        try {
            return new TextStyle().updateTextColor((Color)this.themeService.getCssVariable("-fx-main-gradient-start")).updateFontFamily(transcript.getSpeakerFormattingFont()).updateFontSize(transcript.getSpeakerFormattingSize()).updateBold(transcript.isSpeakerFormattingBold()).updateItalic(transcript.isSpeakerFormattingItalic()).updateUnderline(transcript.isSpeakerFormattingUnderlined());
        }
        catch (URISyntaxException e) {
            log.error("", (Throwable)e);
            return TextStyle.EMPTY;
        }
    }

    public String documentToHtml(Transcript transcript, StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> doc) {
        return TagCreator.document((HtmlTag)TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)transcript.getTranscriptLocation().getFileName().toString())}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.each((Collection)doc.getParagraphs(), paragraph -> TagCreator.p((DomContent[])new DomContent[]{TagCreator.each((Collection)paragraph.getStyledSegments(), segment -> {
            log.debug("HTML Export - Segment: {}, RealText: '{}'", (Object)((AbstractSegment)segment.getSegment()).getClass().getSimpleName(), (Object)((AbstractSegment)segment.getSegment()).getRealText());
            return TagCreator.span((String)((AbstractSegment)segment.getSegment()).getRealText()).withStyle(this.getSegmentStyle(segment).toRealCss());
        })}))})}));
    }

    private TextStyle getSegmentStyle(StyledSegment<AbstractSegment<?>, TextStyle> segment) {
        TextStyle textStyle = (TextStyle)segment.getStyle();
        Object object = segment.getSegment();
        if (object instanceof HasPreDefinedStyle) {
            HasPreDefinedStyle hasPreDefinedStyle = (HasPreDefinedStyle)object;
            textStyle = hasPreDefinedStyle.getTextStyle();
        }
        textStyle = textStyle.updateTextColor(Color.BLACK);
        return textStyle;
    }

    public void reloadTranscriptProperties(Transcript transcript) throws IOException {
        Path transcriptPath = transcript.getTranscriptLocation();
        String unzipUUID = transcript.getUnzipUuid();
        if (this.zipService.isZipFile(transcriptPath)) {
            this.zipService.unzipFile(transcriptPath, this.getTemporaryTranscriptLocation(unzipUUID));
            Transcript loadedTranscript = this.loadProperties(unzipUUID, transcriptPath);
            transcript.reset(loadedTranscript);
            String document = this.loadDocument(transcript);
            if (document != null) {
                transcript.setDocument(document);
            }
        } else {
            log.error("Transcript is not in the right format after migration.");
            this.exceptionAlert.showModal();
        }
    }

    @Generated
    public TranscriptService(ConfigurationService configurationService, ZipService zipService, ObjectMapper objectMapper, ThemeService themeService, MessageService messageService, ExceptionAlert exceptionAlert) {
        this.configurationService = configurationService;
        this.zipService = zipService;
        this.objectMapper = objectMapper;
        this.themeService = themeService;
        this.messageService = messageService;
        this.exceptionAlert = exceptionAlert;
    }

    @Generated
    public FileChooser.ExtensionFilter getEttFilter() {
        return this.ettFilter;
    }

    @Generated
    public Transcript getCurrentTranscript() {
        return this.currentTranscript;
    }

    @Generated
    public void setCurrentTranscript(Transcript currentTranscript) {
        this.currentTranscript = currentTranscript;
    }
}

